/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager;

import ibm.nways.analysis.dpManager.DPERange;
import ibm.nways.analysis.dpManager.OrdinalRangeVector;
import ibm.nways.analysis.dpManager.RangeMarker;
import ibm.nways.analysis.dpManager.ServerOperations;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DPEDirectory
implements Serializable {
    private ServerOperations serverOps;
    private long currentAppletAccessKey = -1L;
    public boolean doNotUseKey = false;
    private OrdinalRangeVector theNewDPERanges = new OrdinalRangeVector();
    private String localDPE;

    public DPEDirectory() {
    }

    public DPEDirectory(OrdinalRangeVector ordinalRangeVector, boolean bl, long l, String string) {
        this.theNewDPERanges = ordinalRangeVector;
        if (bl) {
            ordinalRangeVector.clearServerOperations();
        }
        this.currentAppletAccessKey = l;
        this.localDPE = string;
    }

    public OrdinalRangeVector getOrdinalRangeVector() {
        return this.theNewDPERanges;
    }

    public void setLocalDPE(String string) {
        this.localDPE = string;
    }

    public String getLocalDPE() {
        return this.localDPE;
    }

    public Vector getDPERanges() {
        return this.getDPERanges(null);
    }

    public Vector getDPEList() throws UnknownHostException {
        Vector<String> vector = new Vector<String>();
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        Enumeration enumeration = this.theNewDPERanges.elements();
        while (enumeration.hasMoreElements()) {
            DPERange dPERange = (DPERange)enumeration.nextElement();
            String string = dPERange.getDPEAddress();
            if (hashtable.get(string) != null) continue;
            vector.addElement(string);
            hashtable.put(string, new Boolean(true));
        }
        return vector;
    }

    public String lookup(String string) throws UnknownHostException {
        string = InetAddress.getByName(string).getHostAddress();
        return this.theNewDPERanges.lookup(string);
    }

    public synchronized DPEDirectory copy() {
        this.currentAppletAccessKey = System.currentTimeMillis();
        return new DPEDirectory(this.theNewDPERanges.copy(), true, this.currentAppletAccessKey, this.localDPE);
    }

    public long getKey() {
        return this.currentAppletAccessKey;
    }

    public Vector getDPERanges(String string) {
        Vector<DPERange> vector = new Vector<DPERange>();
        if (string != null) {
            try {
                string = InetAddress.getByName(string).getHostAddress();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Enumeration enumeration = this.theNewDPERanges.elements();
        while (enumeration.hasMoreElements()) {
            DPERange dPERange = (DPERange)enumeration.nextElement();
            if (string != null && dPERange.getDPEAddress().equals(string)) {
                vector.addElement(dPERange);
                continue;
            }
            if (string != null) continue;
            vector.addElement(dPERange);
        }
        return vector;
    }

    public void clearServerOperations() {
        this.serverOps = new ServerOperations();
    }

    public static ServerOperations findDelta(DPEDirectory dPEDirectory, DPEDirectory dPEDirectory2) {
        OrdinalRangeVector ordinalRangeVector = dPEDirectory.getOrdinalRangeVector();
        OrdinalRangeVector ordinalRangeVector2 = dPEDirectory2.getOrdinalRangeVector();
        ordinalRangeVector.clearServerOperations();
        Enumeration enumeration = ordinalRangeVector2.elements();
        while (enumeration.hasMoreElements()) {
            DPERange dPERange = (DPERange)enumeration.nextElement();
            ordinalRangeVector.addRange(dPERange);
        }
        return ordinalRangeVector.getServerOperations();
    }

    public boolean addDPEbyRange(DPERange dPERange) {
        boolean bl = true;
        this.theNewDPERanges.addRange(dPERange);
        return bl;
    }

    public void addDPEbyRange(String string, String string2, String string3) {
        this.theNewDPERanges.addDPEbyRange(new DPERange(string, string2, string3), -1L);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("-----------Directory----------\n");
        stringBuffer.append(String.valueOf(this.theNewDPERanges.toString()) + "\n");
        return stringBuffer.toString();
    }

    public boolean removeDPEbyRange(DPERange dPERange) {
        boolean bl = true;
        new RangeMarker(1, dPERange.getDPEAddress(), dPERange.getStartRange());
        new RangeMarker(2, dPERange.getDPEAddress(), dPERange.getEndRange());
        bl = this.theNewDPERanges.removeFixedRange(dPERange);
        if (this.localDPE != null) {
            this.theNewDPERanges.addRange(new DPERange(this.localDPE, dPERange.getStartRange(), dPERange.getEndRange()));
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        DPEDirectory dPEDirectory = new DPEDirectory();
        dPEDirectory.doNotUseKey = true;
        dPEDirectory.seed();
    }

    public void seed() {
        this.addDPEbyRange("huskernt", "9.85.225.3", "9.85.225.3");
        this.addDPEbyRange("clymer", "9.85.225.3", "9.85.225.3");
        this.addDPEbyRange("lamerok", "9.85.225.3", "9.85.225.3");
        this.addDPEbyRange("clymer", "0.0.0.0", "255.255.255.255");
        this.addDPEbyRange("huskernt", "9.67.0.0", "9.67.255.255");
        this.addDPEbyRange("clymer", "9.100.0.0", "9.100.255.255");
        this.addDPEbyRange("clymer", "9.99.0.0", "9.99.255.255");
        this.addDPEbyRange("clymer", "9.99.83.1", "9.99.83.1");
        this.addDPEbyRange("lamerok", "9.37.231.0", "9.37.231.255");
        this.addDPEbyRange("lamerok", "9.36.231.0", "9.36.231.255");
        this.addDPEbyRange("lamerok", "9.35.0.0", "9.37.255.255");
        this.addDPEbyRange("lamerok", "9.37.231.0", "9.37.231.255");
        this.addDPEbyRange("lamerok", "9.36.231.0", "9.36.231.255");
        this.addDPEbyRange("aikens", "9.37.255.255", "9.37.255.255");
        this.addDPEbyRange("lamerok", "9.67.231.0", "9.255.231.255");
        this.addDPEbyRange("lamerok", "9.57.231.0", "9.67.255.255");
        this.addDPEbyRange("lamerok", "9.1.1.1", "9.1.1.1");
        this.addDPEbyRange("lamerok", "9.1.1.1", "9.1.1.2");
        this.addDPEbyRange("lamerok", "9.255.1.1", "9.255.1.1");
        this.addDPEbyRange("lamerok", "9.255.1.1", "9.255.1.2");
        this.addDPEbyRange("clymer", "9.0.0.0", "9.0.0.0");
        this.addDPEbyRange("huskernt1", "1.0.0.0", "200.0.0.0");
        this.addDPEbyRange("huskernt2", "100.0.0.0", "110.0.0.0");
        this.addDPEbyRange("dpejoe1", "1.0.0.0", "100.0.0.0");
        this.addDPEbyRange("dpejane2", "100.0.0.0", "200.0.0.0");
        this.addDPEbyRange("dpejane3", "100.0.0.0", "200.0.0.0");
        this.addDPEbyRange("dpejoe", "1.0.0.0", "200.0.0.0");
        this.addDPEbyRange("sclymer", "5.0.0.0", "155.0.0.0");
        this.addDPEbyRange("clymer", "0.0.0.25", "255.0.0.0");
        this.addDPEbyRange("wcallen", "0.0.0.1", "0.0.0.1");
        this.addDPEbyRange("lamerok", "0.0.0.0", "255.255.255.255");
        this.addDPEbyRange("clymer", "255.255.255.255", "255.255.255.255");
        this.addDPEbyRange("sclymer", "0.0.0.0", "0.0.0.1");
        this.addDPEbyRange("clymer", "1.1.1.0", "2.2.2.2");
        this.addDPEbyRange("slymer", "2.1.2.1", "2.1.2.1");
        this.addDPEbyRange("huskernt", "7.0.0.0", "7.0.0.0");
        this.addDPEbyRange("huskernt", "7.0.0.0", "7.0.0.0");
        this.addDPEbyRange("clymer", "7.0.0.0", "7.0.0.0");
        this.addDPEbyRange("lamerok", "5.0.0.0", "12.0.0.0");
        this.addDPEbyRange("huskernt", "7.0.0.0", "10.0.0.0");
        this.addDPEbyRange("clymer", "7.0.0.0", "7.0.0.0");
        this.addDPEbyRange("wcallen", "10.0.0.0", "10.0.0.0");
        this.addDPEbyRange("lamerok", "6.0.0.0", "11.0.0.0");
        this.addDPEbyRange("lamerok", "8.0.0.0", "9.0.0.0");
        this.addDPEbyRange("lamerok", "7.0.0.0", "10.0.0.0");
        this.addDPEbyRange("lamerok", "5.0.0.0", "12.0.0.0");
        this.addDPEbyRange("lamerok", "6.0.0.0", "11.0.0.0");
        this.addDPEbyRange("lamerok", "4.0.0.0", "13.0.0.0");
        this.addDPEbyRange("lamerok", "5.0.0.0", "12.0.0.0");
        this.addDPEbyRange("clymer", "6.0.0.0", "7.0.0.0");
        this.addDPEbyRange("huskernt", "4.0.0.0", "8.0.0.0");
        this.addDPEbyRange("huskernt", "4.0.0.0", "12.0.0.0");
        this.addDPEbyRange("lamerok", "5.0.0.0", "12.0.0.0");
        this.addDPEbyRange("clymer", "12.0.0.0", "14.0.0.0");
        this.addDPEbyRange("huskernt", "5.0.0.0", "16.0.0.0");
        this.addDPEbyRange("lamerok", "5.0.0.0", "14.0.0.0");
        this.addDPEbyRange("huskernt", "5.0.0.0", "5.0.0.0");
        this.addDPEbyRange("lamerok", "2.0.0.0", "3.0.0.0");
        this.addDPEbyRange("clymer", "0.0.0.0", "0.0.0.1");
        this.addDPEbyRange("clymer", "1.1.1.0", "2.2.2.2");
        this.addDPEbyRange("clymer", "2.1.2.1", "2.1.2.1");
    }
}

